/*
 * To change this license header, choose License Headers in Project Properties.
 * To change this template file, choose Tools | Templates
 * and open the template in the editor.
 */
package userInterface;

import core.Board;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;

/**
 *
 * @author Drew
 */
public final class BoggleUi //class BoggleUi
{    
    public JFrame JFrame;                  //member variable JFrame of type JFrame
    public JMenuBar JMenuBar;
    public JMenu JMenuBoggle;
    public JMenuItem JMenuItem;
    public JPanel JPanelSouth;
    public JPanel JPanelCenter;
    public JPanel JPanelEast;
    public JButton[][] JButtonofDice[][];
    public JButton JButtonSubmitCurrentWord;            //creating JButton to submit the current word being created
    public JButton JButtonShakeDice;
    public JTextPane JTextArea;
    public JScrollPane JScrollPane;
    public JLabel JLabelPlayerScore;
    public JLabel JLabelCurrentWord;                    //creating JLabel for the current word being created
    public JLabel JLabelTimeLeft;
   
    
    /**
     *
     * 
     * @param board
     */
    
    //custom contratuctor that receivers a parameter of type Board Class
      public BoggleUi(Board board ) 
      {
          
          initComponents();
      }

     
    /**
     *
     */
    public void initComponents()                           //method initComponents          
    {        
                                                            //3a. setPreferredSize requires new dimensions, or can use JFrame.setSize(integer);
      JFrame.setPreferredSize(new Dimension (200,300));     //3a. setting the size of JFrame
      JFrame.setDefaultCloseOperation(0);                   //3b. Setting the default close operation of the JFrame
      JFrame.setLayout(new BorderLayout());                      //setting the layout of JFrame to BorderLayout
      javax.swing.border.Border borderline= BorderFactory.createLineBorder(Color.LIGHT_GRAY);          //creating a border line with the color as light gray
      
      //setting up JMenuBar
      JMenuBoggle = new JMenu("Boggle");            //initializing jmenuBoggle             
      JMenuBar.add(JMenuBoggle);                            //adding JMenuBoggle to JMenuBar 
      
      //adding New Game menu item to the JMenuBar
      JMenuItem = new JMenuItem("New Game");
      JMenuBoggle.add(JMenuItem);
      
      //adding Exit menu item to the JMenuBar
      JMenuItem = new JMenuItem("Exit");
      JMenuBoggle.add(JMenuItem);
      
      //South Panel
      JPanelSouth = new JPanel();
      JLabelCurrentWord = new JLabel ("Current Word");
      JPanelSouth.add(JLabelCurrentWord);       //adding Current Word Label to south panel
      JPanelSouth = new JPanel(new FlowLayout());
      
      JLabelCurrentWord = new JLabel("Current Word");
      JLabelCurrentWord.setBorder(borderline);
      JPanelSouth.add(JLabelCurrentWord);
      
      JButtonSubmitCurrentWord = new JButton("Submit Word");
      JPanelSouth.add(JButtonSubmitCurrentWord);    //adding submit word button to south panel
      
      JLabelPlayerScore = new JLabel("Score");
      JLabelPlayerScore.setBorder(borderline);
      JPanelSouth.add(JLabelPlayerScore);           //adding player score label on south panel
      
      //Center Panel
      JPanelCenter = new JPanel();
      JPanelCenter.setLayout(new GridLayout(4,4));
      
      for (int i = 0; i<16; i++)
      
      
      
      //East Panel
      JPanelEast = new JPanel();
      JPanelEast.setLayout(new BoxLayout(JPanelEast, BoxLayout.Y_AXIS));
      JTextArea = new JTextPane();
      JTextArea.setBorder(borderline);
      JScrollPane = new JScrollPane();      
      JPanelEast.add(JTextArea);              //adding text pane to centerpanel
      JTextArea.add(JScrollPane);             //adding scroll pane to text pane
      
      JLabelTimeLeft = new JLabel("Time Left");
      JLabelTimeLeft.setBorder(borderline);
      JPanelEast.add(JLabelTimeLeft);         //adding JLabelTimeLeft to center panel
      JButtonShakeDice = new JButton("Shake Dice");
      JPanelEast.add(JButtonShakeDice);
      
      
      
      JFrame.add(JMenuBar, BorderLayout.NORTH);
      JFrame.add(JPanelCenter,BorderLayout.CENTER);
      JFrame.add(JPanelEast,BorderLayout.EAST);
      JFrame.add(JPanelSouth, BorderLayout.SOUTH);
      JFrame.pack();
      
      JFrame.setJMenuBar(JMenuBar);                         //Setting JMenuBar to the JFrame
             
      JFrame.setVisible(true);                              //setting the visibility of JFrame
      
        
    }
    
            
}
    

